/*
    names.c - what separates us from the other guys...

    Marc Wolfgram,  6/26/91 18:47:53
    ---------------------------------------------------------------
    v1.0a1
*/

#pragma noroot
#pragma keep "o/names"

#include "Shell.h"
#include <foundation.h>
#include <list.h>
#include <stdio.h>
#include <string.h>

nameSubHndl     loadSubNames(word, word);

extern word fResID, workIndex, nameState;
extern long workTaskMask, *strings;
extern remFileLinkPtr linkREM;
extern remTypeLinkPtr rootREM, currentREM;
extern workFileRec workList[];
extern void         NameProc();
extern GrafPortPtr  nameTargetWinP;
extern EventRecord  fTaskRec;
extern WindColorPtr SysWColor;

char tempBuff[256]; /* used by loadNames and loadSubNames */
char tempName[256];
char nameText[256];
char nullStr = 0x00;
/*--------------------------------------
    loadNames

    Marc Wolfgram,  6/29/91  9:47:13
                    8/24/91 updated for 6.0
*/
word loadNames(word wfd)
{
char *p;
word i, curDepth, resFile, resType, count, items, retVal;
long memSize;
namePtr nameP;
nameHndl nameH;

    SetCurResourceFile(workList[wfd].resFileID);
    curDepth = SetResourceFileDepth(1);

    retVal = 0;
    workList[wfd].resNameHndl = 0L;
    workList[wfd].count = 0;

    count = CountTypes();
    if (count) {
        memSize = nameSize * (long) count;

        nameH = (nameHndl) NewHandle(memSize, fMemID, 0x8018, 0L);
        retVal = toolerror();
        if (!retVal) {
            nameP = (namePtr) deref((Handle) nameH);

            workList[wfd].resNameHndl = nameH;
            workList[wfd].count = count;

            for (i = 0; i < count; i++) {
                resType = GetIndType(i + 1);
                if (resType == rResName) {
                    workList[wfd].count--;
                    nameP[i].nFlag = 0x4000;
                    continue;
                }
                nameP[i].type = resType;
                nameP[i].count = items = (word) CountResources(resType);
                nameP[i].itemHndl = loadSubNames(resType, items);

                getStdName(wfd, (namePtr) &nameP[i], resType);
            }
        }
    }

    SetCurResourceFile(fResID);
    curDepth = SetResourceFileDepth(curDepth);

    return retVal;
}

/*--------------------------------------
    loadSubNames returns an item name array handle

    Marc Wolfgram,  6/29/91  9:47:39
                    8/24/91 updated for 6.0
*/
nameSubHndl loadSubNames(word resType, word resCount)
{
word i, attr, retVal;
long resID, memSize;
nameSubHndl nameSubH;
nameSubPtr  nameSubP;

    retVal = 0;

    memSize = nameSubSize * (long) resCount;
    nameSubH = (nameSubHndl) NewHandle(memSize, fMemID, 0x8018, 0L);
    retVal = toolerror();
    if (!retVal) {
        nameSubP = (nameSubPtr) deref((Handle) nameSubH);

        for (i = 0; i < resCount; i++) {
        	MoonCursor();
            resID = GetIndResource(resType, (long) i + 1);
            nameSubP[i].id = resID;
            nameSubP[i].hitTick = 0L;
            nameSubP[i].hostType = 0;
            nameSubP[i].hostID = 0L;
            RMGetResourceName(resType, resID, tempBuff);
            if (!toolerror()) {
                nameSubP[i].nFlag = 0x8000;
                sprintf(nameSubP[i].name, "*%0.8lX %.31b", resID, tempBuff);
            }
            else {
                nameSubP[i].nFlag = 0;
                sprintf(nameSubP[i].name, "*%0.8lX", resID);
            }
            nameSubP[i].name[0] = (char) strlen(&nameSubP[i].name[1]);
        }
    }
   	ReleaseResource(-1, rResName, (long) resType + 0x10000L);
    HUnlock((Handle) nameSubH);
    SetToolError(retVal);
    return nameSubH;
}

/*--------------------------------------
    saveNames

    Marc Wolfgram,  6/29/91 13:51:20
                    8/24/91 updated for 6.0
*/
void saveNames(word wfd)
{
word i, j, count, countSub, curFile, curDepth, resType;
long resID;
nameHndl        nameH;
namePtr         nameP;
nameSubHndl     nameSubH;
nameSubPtr      nameSubP;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(1);
    SetCurResourceFile(workList[wfd].resFileID);

    nameH = workList[wfd].resNameHndl;
    nameP = (namePtr) deref((Handle) nameH);
    count = workList[wfd].count;

    for (i = 0; i < count; i++) {
    	if (nameP[i].nFlag & 0x4000) {
	    	count++;
			continue;
        }
        resType = nameP[i].type;

        nameSubH = nameP[i].itemHndl;
        nameSubP = (nameSubPtr) deref((Handle) nameSubH);
        countSub = nameP[i].count;

        for (j = 0; j < countSub; j++) {
            if (nameSubP[j].nFlag & 0x4000) {
	    		countSub++;
			    continue;
			}
            MoonCursor();
            if (nameSubP[j].nFlag & 0x8000) {
                resID = nameSubP[j].id;
                nameSubP[j].name[9] = nameSubP[j].name[0] - 9;
                RMSetResourceName(resType, resID, &nameSubP[j].name[9]);
                nameSubP[j].name[9] = 0x20;
            }
        }
    	ReleaseResource(-1, rResName, (long) resType + 0x10000L);
        HUnlock((Handle) nameSubH);
    }
    UpdateResourceFile(workList[wfd].resFileID);
    SetCurResourceFile(curFile);
    curDepth = SetResourceFileDepth(curDepth);

    HUnlock((Handle) nameH);
}

/*--------------------------------------
    killNames

    Marc Wolfgram,  9/16/92 21:18:51
*/
void killNames(word wfd)
{
word i, j, count, countSub, resType;
nameHndl        nameH;
namePtr         nameP;
nameSubHndl     nameSubH;
nameSubPtr      nameSubP;

    nameH = workList[wfd].resNameHndl;
    nameP = (namePtr) deref((Handle) nameH);
    count = workList[wfd].count;

    for (i = 0; i < count; i++) {
    	if (nameP[i].nFlag & 0x4000) {
	    	count++;
			continue;
        }
        resType = nameP[i].type;

        nameSubH = nameP[i].itemHndl;
        nameSubP = (nameSubPtr) deref((Handle) nameSubH);
        countSub = nameP[i].count;

        for (j = 0; j < countSub; j++) {
            if (nameSubP[j].nFlag & 0x4000) {
	    		countSub++;
			    continue;
			}
            MoonCursor();
            if (nameSubP[j].nFlag & 0x8000) {
                nameSubP[j].name[0] = 8;
                nameSubP[j].nFlag &= 0x7fff;
                nameP[i].nFlag |= 0x0001;
                workList[wfd].wFlag |= 0x0001;
            }
        }
        HUnlock((Handle) nameSubH);
    }
    HUnlock((Handle) nameH);
}


/*--------------------------------------
    addItem

    Marc Wolfgram,  9/14/91 12:17:59
*/
word addItem(word wfd, word type, long id, char *rName)
{
int             i, count, realCount, retVal, len;
nameHndl        nameH;
namePtr         nameP;
nameSubHndl     nameSubH;
nameSubPtr      nameSubP;
fListCtlRecHndl listCtlH;
GrafPortPtr     winP;
fEventRec       eventPB;


/* first - make sure there is a receiving nameRec... */

    count = workList[wfd].count;
    workList[wfd].wFlag |= 0x4001;      /* dirty file and type */

    if (!count) {                       /* the file was empty */
        nameH = (nameHndl) NewHandle(nameSize, fMemID, 0x8018, 0L);
        retVal = toolerror();
        if (retVal)
            return retVal;
        workList[wfd].resNameHndl = nameH;
        workList[wfd].wFlag |= 0x0002;      /* dirty root too */
        nameP = (namePtr) *nameH;           /* the new entry */
        nameP->nFlag = 0x4000;              /* new is free */
    }
    else {                              /* the file has some stuff in it */
        nameP = getNameRec(wfd, type);
        if (!nameP) {                       /* but no type matches ours */
            nameH = workList[wfd].resNameHndl;
            nameP = *nameH;
            realCount = GetHandleSize((Handle) nameH) / nameSize;
            for (i = 0; i < realCount; i++) {   /* look for a free entry */
                if (nameP[i].nFlag & 0x4000) {
                    nameP = &nameP[i];
                    break;
                }
            }
            if (nameP->nFlag != 0x4000) {       /* no free entry found */
                HUnlock((Handle) nameH);
                SetHandleSize((LongWord) (GetHandleSize((Handle) nameH) + nameSize), (Handle) nameH);
                retVal = toolerror();
                HLock((Handle) nameH);
                if (retVal)
                    return retVal;
                nameP = (namePtr) *nameH;
                nameP = &nameP[count];              /* the new entry */
                nameP->nFlag = 0x4000;              /* new is free */
            }
        }
    }

/* second - set root and make sure there is a receiving nameSubRec... */

    if (nameP->nFlag == 0x4000) {       /* we've created a new type entry */
        nameSubH = (nameSubHndl) NewHandle(nameSubSize, fMemID, 0x8018, 0L);
        retVal = toolerror();
        if (retVal)
            return retVal;
        workList[wfd].count++;
        workList[wfd].wFlag |= 0x0002;      /* dirty root too */
        nameP->type = type;
        nameP->itemHndl = nameSubH;
        nameP->count = 0;
        getStdName(wfd, nameP, type);
        nameSubP = (nameSubPtr) deref((Handle) nameSubH);  /* the new entry */
    }
    else {                              /* there was a type entry */
        count = nameP->count;
        nameSubH = nameP->itemHndl;
        nameSubP = *nameSubH;
        realCount = GetHandleSize((Handle) nameSubH) / nameSubSize;
        for (i = 0; i < realCount; i++) {   /* look for a free item entry */
            if (nameSubP[i].nFlag & 0x4000) {
                nameSubP = &nameSubP[i];
                break;
            }
        }
        if (nameSubP->nFlag != 0x4000) {    /* no free entry found */
            HUnlock((Handle) nameSubH);
            SetHandleSize((LongWord) (GetHandleSize((Handle) nameSubH) + nameSubSize), (Handle) nameSubH);
            retVal = toolerror();
            HLock((Handle) nameH);
            if (retVal)
                return retVal;
            nameSubP = *nameSubH;
            nameSubP = &nameSubP[count];    /* the new entry */
        }
    }

/* third - stuff in the item data */

    nameP->count++;
    nameP->nFlag = 0x0001;                  /* busy with dirty type */
    nameSubP->id = id;
    nameSubP->hitTick = GetTick();
    nameSubP->hostType = 0;
    nameSubP->hostID = 0L;
    if (!rName) {
        len = sprintf(nameSubP->name, "*%0.8lX", id);
        nameSubP->nFlag = 0;
    }
    else {
        len = sprintf(nameSubP->name, "*%0.8lX %b", id, rName);
        nameSubP->nFlag = 0x8000;
    }
    nameSubP->name[0] = (char) len - 1;

/* last - call a native selector with add */

    winP = findSignature(REM_signature + REM_nselector + wfd, 0, type, 0L);
    if (winP) {
        fTaskRec.wmTaskData = (long) winP;
        eventPB.resType = type;
        eventPB.resID = id;
        eventPB.fFlag = 0x0400;
        eventPB.taskCode = 12;              /* app1Evt - add selector item */
        callREM(_EVENT, (Pointer) &eventPB);
    }
    return retVal;
}

/*--------------------------------------
    changeItem

    Marc Wolfgram,  9/14/91 12:17:59
*/
void changeItem(word wfd, word type, long id, long newid, char *rName)
{
word            i, count, len;
long            oldResFile;
namePtr         nameP;
nameSubPtr      nameSubP;
fListCtlRecHndl listCtlH;
GrafPortPtr     winP;
fEventRec       eventPB;

    nameP = getNameRec(wfd, type);
    count = nameP->count;
    nameSubP = (nameSubPtr) *(nameP->itemHndl);
    for (i = 0; i < count; i++) {
        if (nameSubP[i].nFlag & 0x4000) {
        	count++;
	        continue;
		}
        if (nameSubP[i].id == id) {
            nameSubP = &nameSubP[i];
            if (newid) {
	            workList[wfd].wFlag |= 0x0005;
	            nameSubP->id = newid;
	        }
            if ((long) rName != 0L) {
                if (rName[0]) {
                    len = sprintf(nameSubP->name, "*%0.8lX %b", nameSubP->id, rName);
            		nameP->nFlag |= 0x0001;
                    nameSubP->nFlag = 0x8001;
                }
                else  {
                    len = sprintf(nameSubP->name, "*%0.8lX", nameSubP->id);
            		nameP->nFlag |= 0x0001;
                    nameSubP->nFlag = 0x0001;
                    oldResFile = SetResFile2(workList[wfd].resFileID, 1);
                    RMSetResourceName(type, id, (Ptr) &nullStr);
                    SetResFile1(oldResFile);
                }
                nameSubP->name[0] = (char) len - 1;
            }
            else {
                nameSubP->nFlag |= 0x0001;
                sprintf(&nameSubP->name[1], "%0.8lX", nameSubP->id);
                if (nameSubP->name[0] > 8)
                    nameSubP->name[9] = 0x20;
            }
            nameP->nFlag |= 0x0001;
            workList[wfd].wFlag |= 0x0001;
            break;
        }
    }

/* call a native selector with delete/add or rename
   call an open editor with rename for title update */

    eventPB.resType = type;
    eventPB.resID = id;
    eventPB.fFlag = 0x0400;

    if (newid) {
        winP = findSignature(REM_signature + REM_nselector + wfd, 0, type, 0L);
        if (winP) {
            fTaskRec.wmTaskData = (long) winP;
            eventPB.taskCode = 13;      /* app1Evt - delete selector item */
            callREM(_EVENT, (Pointer) &eventPB);
            eventPB.resID = newid;
            eventPB.taskCode = 12;      /* app2Evt - add selector item */
            callREM(_EVENT, (Pointer) &eventPB);
        }
    }
    else if (rName) {
        eventPB.taskCode = 14;
        winP = findSignature(REM_signature + REM_nselector + wfd, 0, type, 0L);
        if (winP) {
            fTaskRec.wmTaskData = (long) winP;
            callREM(_EVENT, (Pointer) &eventPB);
        }

        winP = findSignature(REM_signature + REM_native + wfd, 0, type, id);
        if (winP) {
            fTaskRec.wmTaskData = (long) winP;
            eventPB.fFlag = 0x0000;
            callREM(_EVENT, (Pointer) &eventPB);
        }
        else {
            winP = findSignature(REM_signature + REM_script + wfd, 0, type, id);
            if (winP) {
                fTaskRec.wmTaskData = (long) winP;
                eventPB.fFlag = 0x1000;
                callREM(_EVENT, (Pointer) &eventPB);
            }
            else {
                winP = findSignature(REM_signature + REM_hexascii + wfd, 0, type, id);
                if (winP) {
                    fTaskRec.wmTaskData = (long) winP;
                    eventPB.fFlag = 0x0800;
                    callREM(_EVENT, (Pointer) &eventPB);
                }
            }
        }
    }
    workList[wfd].wFlag |= 0x4001;
    nameP->nFlag |= 0x0001;
}

/*--------------------------------------
    deleteItem

    Marc Wolfgram,  9/12/91 21:22:54
*/
void deleteItem(word wfd, word type, long id)
{
word            count, countSub;
long            oldResFile;
fWindowRecHndl  refH;
namePtr         nameP;
nameSubPtr      nameSubP;
fListCtlRecHndl listCtlH;
GrafPortPtr     winP;
fCloseRec       closePB;
fEventRec       eventPB;

    nameSubP = getNameSubRec(wfd, type, id);
    if (!nameSubP)
    	return;

/* first shut down the item if it's active in an editor */
    winP = findSignature(REM_signature + REM_native + wfd, 0, type, id) +
           findSignature(REM_signature + REM_script + wfd, 0, type, id) +
           findSignature(REM_signature + REM_hexascii + wfd, 0, type, id);
    if (winP) {
        refH = (fWindowRecHndl) GetWRefCon(winP);
        closePB.resType = type;
        closePB.resID = id;
        closePB.windowPtr = (Pointer) winP;
        switch ((**refH).Signature & 0x0060) {
        case REM_script:
            closePB.fFlag = 0x1000;
            break;
        case REM_hexascii:
            closePB.fFlag = 0x0800;
            break;
        default:
            closePB.fFlag = 0x0000;
            break;
        }
        callREM(_CLOSE, (Pointer) &closePB);
    }

/* second - blow out the item */

    nameP = getNameRec(wfd, type);

    workList[wfd].wFlag |= 0x4001;      /* dirty file */
    nameP->count--;                     /* countdown to entropy */
    nameP->nFlag = 0x0005;              /* busy, select, dirty type */
    nameSubP->id = 0L;                  /* clear record... */
    nameSubP->nFlag = 0x4000;
    nameSubP->hitTick = 0L;
    nameSubP->hostType = 0;
    nameSubP->hostID = 0L;
    nameSubP->name[0] = 0x00;

    oldResFile = SetResFile2(workList[wfd].resFileID, 1);
    RMSetResourceName(type, id, &nullStr);
    SetResFile1(oldResFile);

/* third - blow out the type if possible */

    if (nameP->count) {                 /* more of this type left */
        workList[wfd].wFlag |= 0x0001;  /* dirty type */
        nameP->nFlag = 0x0001;          /* mark dirty type */
        winP = findSignature(REM_signature + REM_nselector + wfd, 0, type, 0L);
        if (winP) {                         /* let the native selector know */
            fTaskRec.wmTaskData = (long) winP;
            eventPB.resType = type;
            eventPB.resID = id;
            eventPB.fFlag = 0x0400;
            eventPB.taskCode = 13;          /* app2Evt - remove selector item */
            callREM(_EVENT, (Pointer) &eventPB);
        }
    }
    else {                      /* that's all for this baby */
        workList[wfd].wFlag |= 0x0006;      /* select, dirty root */
        winP = findSignature(REM_signature + REM_tselector + wfd, 0, type, 0L);
        if (winP) {
            listCtlH = (fListCtlRecHndl) GetCtlHandleFromID(winP, 2L);
            if ((**listCtlH).ctlListRef) {
                DisposeHandle((Handle) (**listCtlH).ctlListRef);
                (**listCtlH).ctlListRef = 0L;
            }
            DisposeHandle((Handle) GetWRefCon(winP));
            CloseWindow(winP);
        }
        else {
            winP = findSignature(REM_signature + REM_nselector + wfd, 0, type, 0L);
            if (winP) {
                closePB.resType = type;
                closePB.resID = id;
                closePB.fFlag = 0x0400;
                closePB.windowPtr = (Pointer) winP;
                callREM(_CLOSE, (Pointer) &closePB);
            }
        }
        if (nameP->itemHndl)
            DisposeHandle((Handle) nameP->itemHndl);
        workList[wfd].count--;
        if (workList[wfd].count) {
            nameP->type = 0;                /* clear record... */
            nameP->nFlag = 0x4000;              /* mark empty */
            nameP->itemHndl = 0L;
            nameP->count = 0;
            nameP->name[0] = 0x00;
            nameP->winT[0] = 0x00;
        }
        else {
            if (workList[wfd].resNameHndl)
                DisposeHandle((Handle) workList[wfd].resNameHndl);
            workList[wfd].resNameHndl = 0L;
            winP = workList[wfd].rootWinP;
            listCtlH = (fListCtlRecHndl) GetCtlHandleFromID(winP, 2L);
            if ((**listCtlH).ctlListRef) {
                DisposeHandle((Handle) (**listCtlH).ctlListRef);
                (**listCtlH).ctlListRef = 0L;
            }
        }
    }
}

/*--------------------------------------
    getNameRec

    Marc Wolfgram,  9/11/91  0:37:35
*/
namePtr getNameRec(word wfd, word type)
{
int         i, count;
namePtr     nameP, retVal;

    retVal = 0L;
    nameP = (namePtr) *(workList[wfd].resNameHndl);
    count = workList[wfd].count;
    for (i = 0; i < count; i++) {
    	if (nameP[i].nFlag & 0x4000) {
	    	count++;
			continue;
		}
        if (nameP[i].type == type) {
            retVal = &nameP[i];
            break;
        }
    }
    return retVal;
}

/*--------------------------------------
    getNameSubRec

    Marc Wolfgram,  9/11/91  0:38:27
*/
nameSubPtr getNameSubRec(word wfd, word type, long id)
{
int         i, count;
namePtr     nameP;
nameSubPtr  nameS, retVal;

    retVal = 0L;
	nameP = getNameRec(wfd, type);
    if (nameP) {
        nameS = (nameSubPtr) *(nameP->itemHndl);
        count = nameP->count;
        for (i = 0; i < count; i++) {
    		if (nameS[i].nFlag & 0x4000) {
	    		count++;
			    continue;
			}
            if (nameS[i].id == id) {
                retVal = &nameS[i];
                break;
            }
        }
    }
    return retVal;
}

/*--------------------------------------
    getStdName

    Marc Wolfgram,  9/14/91 12:43:49
*/
void getStdName(word wfd, namePtr nameP, word type)
{
word curFile, curDepth, wlen, nlen;
char *p;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(1);
    SetCurResourceFile(fResID);

    RMGetResourceName(rResName, (long) type + 0x10000L, (Ptr) tempBuff);
    if (!toolerror()) {
        wlen = sprintf(nameP->winT, "* %.31b (%u) ", tempBuff, wfd + 1);
        nlen = sprintf(nameP->name, "*%0.4X %.31b", type, tempBuff);
    	ReleaseResource(-1, rResName, (long) type + 0x10000L);
    }
    else {
        p = getREMTypeName(type);
        if (p) {
            wlen = sprintf(nameP->winT, "* %.31b (%u) ", p, wfd + 1);
            nlen = sprintf(nameP->name, "*%0.4X %.31b", type, p);
        }
        else if (type < 0x8000) {
            wlen = sprintf(nameP->winT, (char *) strings[15], type, wfd + 1);
            nlen = sprintf(nameP->name, (char *) strings[17], type);
        }
        else {
            wlen = sprintf(nameP->winT, (char *) strings[13], type, wfd + 1);
            nlen = sprintf(nameP->name, (char *) strings[16], type);
        }
    }
    nameP->winT[0] = (char) wlen - 1;
    nameP->name[0] = (char) nlen - 1;

    SetCurResourceFile(curFile);
    curDepth = SetResourceFileDepth(curDepth);
}

/*--------------------------------------
    getHitTick

    Marc Wolfgram,  7/ 4/91 22:52:12
*/
long getHitTick(word wfd, word resType, long resID)
{
nameSubPtr  nameSubP;

    nameSubP = getNameSubRec(wfd, resType, resID);
    if (nameSubP)
        return nameSubP->hitTick;

    return 0L;
}

/*--------------------------------------
    setHitTick

    Marc Wolfgram,  7/ 4/91 22:52:51
*/
void setHitTick(word wfd, word resType, long resID)
{
nameSubPtr  nameSubP;

    nameSubP = getNameSubRec(wfd, resType, resID);
    if (nameSubP)
        nameSubP->hitTick = GetTick();
}

/*--------------------------------------
    openNamer

    Marc Wolfgram, 10/29/91 16:52:07
*/
void openNamer()
{
fWindowRecHndl  refH;
fWindowRecPtr   refP;
GrafPortPtr     winP;

    winP = findSignature(REM_signature + 0x00e8, 0, 0, 0L);
    if (winP) {
        SelectWindow(winP);
        return;
    }
    refH = (fWindowRecHndl) NewHandle(20L, fMemID, 0x0018, 0L);
    refP = (fWindowRecPtr) deref((Handle) refH);
    refP->Signature     = REM_signature + 0xe8;
    refP->resType       = 0;
    refP->resID         = 0L;
    refP->resFileID     = 0;
    refP->remTaskMask   = 0x001f7fffL;
    refP->remSignature  = 0;
    refP->resPrivate    = 0L;
    HUnlock((Handle) refH);

    winP = NewWindow2(0L, (Long) refH, (VoidProcPtr) &NameProc, 0L, 2, 0x00000efeL, 0x800e);
    SetPort(winP);
    CenterWindow(winP);
    SetFrameColor(SysWColor, winP);
    ShowWindow(winP);

    nameState = 0x00ff; /* start off with this puppy disabled */
}

/*--------------------------------------
    drawNamer

    Marc Wolfgram, 10/29/91 18:45:12
*/
void drawNamer(GrafPortPtr theP)
{
word            nlen, hilite, listItem;
Rect            dRect;
fWindowRecHndl  refH;
fResNameRec     namePB;
GrafPortPtr     winP, oldP;
fListCtlRecHndl ctlH;
fMemberHndl     memH;
fMemberPtr      memP;

    winP = findSignature(REM_signature + 0x00e8, 0, 0, 0L);
    if (winP) {
        if (theP) {
            refH = (fWindowRecHndl) GetWRefCon(theP);
            namePB.pCount = 3;
            namePB.resType = (**refH).resType;
            namePB.resID = (**refH).resID;
            if (namePB.resType & 0x7fff) {
                if (!namePB.resID) { /* typical non-editor */
        		    ctlH = (fListCtlRecHndl) GetCtlHandleFromID(theP, 2L);
        		    listItem = NextMember2(0, (Handle) ctlH);
                    if (listItem) {
                	    memH = (**ctlH).ctlListRef;
        			    memP = (fMemberPtr) deref((Handle) memH);
            		    namePB.resID = memP[listItem-1].nref;
        		    }
                }
                if (namePB.resID) {
            	    namePB.resName = &nameText[64];

            	    remGetStdTypeName(&namePB);
            	    if (nameText[64])
                	    nlen = sprintf(&nameText[128], (char *) strings[22], namePB.resType, &nameText[64], (char) workIndex + '1');
            	    else
                	    nlen = sprintf(&nameText[128], (char *) strings[23], namePB.resType, (char) workIndex + '1');
            	    nameText[128] = (char) nlen - 1;
            	    sprintf(&nameText[192], "\x08%0.8lX", namePB.resID);
            	    remGetResourceName(&namePB);
            	    hilite = 0;
        	    }
        	    else {
            	    sprintf(&nameText[128], (char *) strings[30]);
            	    nameText[192] = 0x00;
            	    nameText[64] = 0x00;
            	    hilite = 0x00ff;
                }
            }
            else {
                sprintf(&nameText[128], (char *) strings[31]);
                nameText[192] = 0x00;
                nameText[64] = 0x00;
                hilite = 0x00ff;
            }
        }
        else {
            sprintf(&nameText[128], (char *) strings[31]);
            nameText[192] = 0x00;
            nameText[64] = 0x00;
            hilite = 0x00ff;
        }
        oldP = GetPort();
        SetPort(winP);

        dRect.v1 = 4;       /* first blast the type space */
        dRect.h1 = 10;
        dRect.v2 = 13;
        dRect.h2 = 300;
        EraseRect(&dRect);
        InvalRect(&dRect);

        dRect.v1 = 13;      /* then say goodbye to the id */
        dRect.h1 = 42;
        dRect.v2 = 22;
        dRect.h2 = 300;
        EraseRect(&dRect);
        InvalRect(&dRect);

        SetLETextByID(winP, 2L, (StringPtr) &nameText[64]);
        HiliteControl(hilite | nameState, GetCtlHandleFromID(winP, 1L));
        HiliteControl(hilite, GetCtlHandleFromID(winP, 2L));
        SetPort(oldP);
    }
}
